<?php
require_once( "utility.php" ) ;

function sync_to_controller( $sc_id ) {
    debug_print( "SyncMsIpToSc: sc_id='$sc_id'" ) ;
    $ms_ip = null ;
    
    # Local SC
    $ms_ip = ( $sc_id == 1 ) ?
        ConfManager::get( "/configuration/management_server/internal/ip" ) :
        ConfManager::get( "/configuration/management_server/ip" ) ;

    CommonUtility::debug_print( "SyncMsIpToSc: ms_ip='$ms_ip'" ) ;        
    if( CommonUtility::isIpValid( $ms_ip ) == false ) {
        throw new Exception( "InvalidIp: ms_ip='$ms_ip'" ) ;
    }
    
    $oriWbfsUrl      = ConfManager::get( "/configuration/wbfs/url" ) ;
    $oriHeartbeatUrl = ConfManager::get( "/configuration/sc_heart_beat/url" ) ;
    $oriUpdateUrl    = ConfManager::get( "/configuration/update/url" ) ;
    $regPattern      = "/[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}/" ;
    
    $db_ip           = $ms_ip ;
    $newWbfsUrl      = preg_replace( $regPattern, $ms_ip, $oriWbfsUrl ) ;
    $newHeartbeatUrl = preg_replace( $regPattern, $ms_ip, $oriHeartbeatUrl ) ;
    $newUpdateUrl    = preg_replace( $regPattern, $ms_ip, $oriUpdateUrl ) ;

    # arguments_array
    $program    = "/opt/TrendMicro/DTAS/SandboxController/bin/dtascfg" ;
    $arguArrays = array(
        array( "/etc/dtascfg.xml", "set", "db",            "host",     $db_ip,           0 ),
        array( "/etc/dtascfg.xml", "set", "wbfs",          "url",      $newWbfsUrl,      0 ),
        array( "/etc/dtascfg.xml", "set", "sc_heart_beat", "url",      $newHeartbeatUrl, 0 ),
        array( "/etc/dtascfg.xml", "set", "update",        "url",      $newUpdateUrl,    0 ),
        array( "/etc/dtascfg.xml", "set", ".",             "version",  0,                0 )
    ) ;

    $scInfoArray = ConfManager::getScInfo( $sc_id ) ;
    foreach( $arguArrays as $arguArray ) {
        ScManager::stepRunProgramBySsh( $sc_id, array(
            "stepname"  => "UpdateXml", 
            "program"   => $program,
            "arguments" => $arguArray ) ) ;
    }
    
    # set DNS server for SC
    $msInfoArray = ConfManager::getMsInfo( $sc_id ) ;
    $dns = trim( $msInfoArray[ "dns" ] ) ;
    ScManager::stepRunProgramBySsh( $sc_id, array(
        "stepname"  => "UpdateScDNS: sc_id='$sc_id', dns='$dns', ",
        "pipe_to"   => "/etc/resolv.conf",
        "program"   => "/bin/echo",
        "arguments" => array(
            "nameserver $dns\n"
    ) ) ) ;


    # set ESXi to get DNS by static way    
    $esxiInfoArray = ConfManager::getEsxiInfo( $sc_id ) ;
    $portnumber = getEsxiPort($esxiInfoArray[ "ip" ]);
    CommonUtility::stepRunProgramAtMs( array(
        "stepname"  => "DisableEsxiDnsDhcp",
        "program"   => "/usr/bin/vicfg-dns",
        "arguments" => array(
            "--server",    $esxiInfoArray[ "ip" ],
            "--portnumber", $portnumber,
            "--username",  $esxiInfoArray[ "username" ],
            "--password",  $esxiInfoArray[ "password" ],
            "--dhcp",      "no"
    ) ) ) ;

    # set DNS server for ESXi
    CommonUtility::stepRunProgramAtMs( array(
        "stepname"  => "SetEsxiDnsConf",
        "program"   => "/usr/bin/vicfg-dns",
        "arguments" => array(
            "--server",    $esxiInfoArray[ "ip" ],
            "--portnumber", $portnumber,
            "--username",  $esxiInfoArray[ "username" ],
            "--password",  $esxiInfoArray[ "password" ],
            "--dhcp",      "no",
            "--dns",       $dns
    ) ) ) ;

    echo "$db_ip, $newWbfsUrl, $newHeartbeatUrl, $newUpdateUrl" ;
    exit( 0 ) ;
}

function sync_server_ip_to_controller( $argv ) {
    $db_connect = false ;
    
    try {
    
        /* check number of arguments */
        if( count( $argv ) != 2 ) {
            $msg = "Usage: " . basename( __FILE__, ".inc" ) . " <ManagementServerIp> <SandboxControllerId>" ;
            throw new Exception( $msg ) ;
        }
        
        $ms_ip = $argv[ 0 ] ;
        $sc_id = $argv[ 1 ] ;
        
        # all SC
        if( $sc_id == 0 ) {
            $result = DbManager::query( 'SELECT sc_id FROM tb_sc_info WHERE sc_id > 0' ) ;
            $sc_ids = pg_fetch_all( $result ) ;
            $sc_ids = $sc_ids[ 0 ] ;
            
            CommonUtility::debug_print( "sc_id_list: '" . join( ",", $sc_ids ) . "'" ) ;
            foreach( $sc_ids as $sc_id ) {
                sync_to_controller( $sc_id ) ;
            }
        }
        
        else {
            sync_to_controller( $sc_id ) ;
        }
    }
    
    catch( Exception $e ) {
        $msg = "[" . $e -> getFile() . "(" . $e -> getLine() . ")]: " . $e -> getMessage() ;
        CommonUtility::debug_print( "Exception caught: $msg" ) ;
        
        if( $db_connect !== false ) {
            pg_close( $db_connect ) ;
        }
        
        exit( 1 ) ;
    }
}